function thread.shell()
  local line = ''
  local prompt = '--> '
  while true do
    io.write(prompt)
    prompt = '--> '
    line = line .. thread.gets(1000)
    if line == 'quit\n' then return end
    line = line:gsub('^=', 'return ')
    local fct, err = loadstring(line, '@stdin')
    if fct then
      local res = { pcall(fct) }
      if not res[1] or #res > 1 then
        print(unpack(res, 2, #res))
      end
      line = ''
    elseif err:sub(-7,-1) == "'<eof>'" then
      prompt = '-->>  '
    else
      print(err)
      line = ''
    end
  end
end

function thread.sched(threads)
  while next(threads) do
    local thr = thread.wait()
    if not thr then thr = next(threads) end
    local res, errmsg = coroutine.resume(thr, thread)
    collectgarbage()
    if not res then
      if errmsg ~= 'cannot resume dead coroutine' then
        print(errmsg)
      end
      threads[thr] = nil
    end
  end
end

local function sleep(id)
  return function()
    for i=1,10 do
      print(string.format("Sleep thread %d at loop %d", id, i))
      thread.sleep(math.random(10000))
    end
  end
end

local function run_sleep(id)
  return function()
    for i=1,10 do
      print(string.format("System thread %d at loop %d", id, i))
      thread.system('sleep '..math.random(10)+1)
    end
  end
end

local function wget(id)    
  return function()
    for i=1,10 do
      print(string.format("Wget thread %d at loop %d", id, i))
      thread.wget("opengroup.org", "/onlinepubs/007908799/xns/netdb.h.html")
    end
  end
end


local t = {}
local cnt_thread = 0
local function add_thread(fct)
  local co = coroutine.create(fct)
  t[co] = true
  coroutine.resume(co)
  cnt_thread = cnt_thread + 1
end

add_thread(thread.shell)
for i=1,3 do 
  add_thread(sleep(cnt_thread))
  add_thread(run_sleep(cnt_thread))
  add_thread(wget(cnt_thread))
end

thread.sched(t)
